@echo off
set Name="RemoteAccess_nebula-6527dd87.d2ns-nbl.com"
set ServerAddress="nebula-6527dd87.d2ns-nbl.com"
set TunnelType="IKEv2"
set AuthenticationMethod="EAP"
set EncryptionLevel="Required"
set UseWinlogonCredential=$False
set RememberCredential=$False
set SplitTunneling=$False
set IKEEnc="AES256"
set IKEAuth="SHA256"
set IKEKey="Group14"
set ESPEnc="AES256"
set ESPAuth="SHA256"
set ESPPfs="None"
:: Installing CA certificate requires Administrator privileges.
call :isAdmin

:: Check Administrator priviledges and run alternative action
if %errorlevel% == 0 (
	goto :run
) else if "%1" == "admin_session" (
	goto :run
) else if %errorlevel% == 1 (
	goto :UACPrompt
) else (
	echo "Could not get administrative privileges"
	pause
	exit /b
)

:isAdmin
	fsutil dirty query %systemdrive% >nul 2>&1
	exit /b

:run
	cd /d %~dp0
	powershell -ExecutionPolicy Bypass -NonInteractive -Command "& {Get-ChildItem -Path .\RemoteAccess_Windows_IPSec_VPN.crt | Import-Certificate -CertStoreLocation cert:\LocalMachine\root}"
	exit /b

	:UACPrompt
	echo Requesting administrative privileges to install the IKEv2 VPN CA certificate...
	echo Set UAC = CreateObject^("Shell.Application"^) > "%temp%\getadmin.vbs"
	echo UAC.ShellExecute "cmd.exe", "/c ""%~s0"" admin_session", "", "runas", 1 >> "%temp%\getadmin.vbs"
	"%temp%\getadmin.vbs"
	del "%temp%\getadmin.vbs"
	echo "Install the IKEv2 VPN CA certificate..."

powershell -ExecutionPolicy Bypass -command "Get-VpnConnection -Name %Name% -ErrorAction SilentlyContinue"

if %errorlevel% == 0 (
	goto :UpdateVPN
) else (
	goto :AddVPN
)

:AddVPN
	powershell -ExecutionPolicy Bypass -command "Add-VpnConnection -Name %Name% -ServerAddress %ServerAddress% -TunnelType %TunnelType% -EncryptionLevel %EncryptionLevel% -AuthenticationMethod %AuthenticationMethod% -Force"
	powershell -ExecutionPolicy Bypass -command "Set-VpnConnection -Name %Name% -SplitTunneling %SplitTunneling% -RememberCredential %RememberCredential% -Force"
	powershell -ExecutionPolicy Bypass -command "Set-VpnConnectionIPsecConfiguration -ConnectionName %Name% -EncryptionMethod %IKEEnc% -IntegrityCheckMethod %IKEAuth% -DHGroup %IKEKey% -CipherTransformConstants %ESPEnc% -AuthenticationTransformConstants %ESPAuth% -PfsGroup %ESPPfs% -Force"
	powershell -ExecutionPolicy Bypass -command "Write-Host \"Create the %Name% VPN connection\""
	pause
	exit /b

:UpdateVPN
	powershell -ExecutionPolicy Bypass -command "Set-VpnConnection -Name %Name% -ServerAddress %ServerAddress% -TunnelType %TunnelType% -EncryptionLevel %EncryptionLevel% -AuthenticationMethod %AuthenticationMethod% -SplitTunneling %SplitTunneling% -Force"
	powershell -ExecutionPolicy Bypass -command "Set-VpnConnectionIPsecConfiguration -ConnectionName %Name% -EncryptionMethod %IKEEnc% -IntegrityCheckMethod %IKEAuth% -DHGroup %IKEKey% -CipherTransformConstants %ESPEnc% -AuthenticationTransformConstants %ESPAuth% -PfsGroup %ESPPfs% -Force"
	powershell -ExecutionPolicy Bypass -command "Write-Host \"Updated the %Name% VPN connection\""
	pause
	exit /b

exit /b